<?php
// Add custom Theme Functions here
// 
//Remove (0) from Reviews when there are no counts
add_filter( 'woocommerce_product_tabs', 'wp_woo_rename_reviews_tab', 98);
function wp_woo_rename_reviews_tab($tabs) {
    global $product;
    $check_product_review_count = $product->get_review_count();
    if ( $check_product_review_count == 0 ) {
        $tabs['reviews']['title'] = 'Reviews';
    } else {
        $tabs['reviews']['title'] = 'Reviews('.$check_product_review_count.')';
    }
    return $tabs;
}

//add/modify custom shipping zones
add_filter( 'woocommerce_states', 'custom_woocommerce_states' );

function custom_woocommerce_states( $states ) {
$states['NG'] = array(
	'LA'=> __( 'Lagos', 'woocommerce' ),
    'AKU' => __( 'Akure', 'woocommerce' ),
		'ABV' => __( 'Abuja', 'woocommerce' ),
		'AUC' => __( 'Auchi', 'woocommerce' ),
		'AKW' => __( 'Akwa', 'woocommerce' ),
		'BNI' => __( 'Benin', 'woocommerce' ),
		'EKP' => __( 'Ekpoma', 'woocommerce' ),
		'WAR' => __( 'Warri', 'woocommerce' ),
		'IBA' => __( 'Ibadan', 'woocommerce' ),
		'IFE' => __( 'Ife', 'woocommerce' ),
		'ILR' => __( 'Ilorin', 'woocommerce' ),
		'ABA' => __( 'Aba', 'woocommerce' ),
		'UMA' => __( 'Umuahia', 'woocommerce' ),
		'UYO' => __( 'Uyo', 'woocommerce' ),
		'YEN' => __( 'Yenagoa', 'woocommerce' ),
		'ASA' => __( 'Asaba', 'woocommerce' ),
		'CAL' => __( 'Calabar', 'woocommerce' ),
		'ENU' => __( 'Enugu', 'woocommerce' ),
		'NNI' => __( 'Nnewi', 'woocommerce' ),
		'KD' => __( 'Kaduna', 'woocommerce' ),
		'KN' => __( 'Kano', 'woocommerce' ),
		'ONI' => __( 'Onitsha', 'woocommerce' ),
		'ZRI' => __( 'Zaria', 'woocommerce' ),
		'OWR' => __( 'Owerri', 'woocommerce' ),
		'OSO' => __( 'Osogbo', 'woocommerce' ),
		'PHC' => __( 'Port-Harcourt', 'woocommerce' ),
		'JOS' => __( 'Jos', 'woocommerce' ),
);
	  return $states;
}
/**Change the Add to Cart text***/
add_filter( 'add_to_cart_text', 'woo_custom_single_add_to_cart_text' );                // < 2.1
add_filter( 'woocommerce_product_single_add_to_cart_text', 'woo_custom_single_add_to_cart_text' );  // 2.1 +
  
function woo_custom_single_add_to_cart_text() {
  
    return __( 'Add to Basket', 'woocommerce' );
  
}

add_filter( 'add_to_cart_text', 'woo_custom_product_add_to_cart_text' );            // < 2.1
add_filter( 'woocommerce_product_add_to_cart_text', 'woo_custom_product_add_to_cart_text' );  // 2.1 +
  
function woo_custom_product_add_to_cart_text() {
  
    return __( 'Add to Basket', 'woocommerce' );
  
}

/****Reorder Checkout fields*****/

add_filter("woocommerce_checkout_fields", "custom_order_fields");

function custom_order_fields($fields) {
$order = array(
“billing_email”,
“billing_first_name”,
“billing_last_name”,
“billing_phone”,
“billing_country”,
“billing_state”,
“billing_city”,
“billing_address_1”,
);
foreach($order as $field)
{
$ordered_fields[$field] = $fields[“billing”][$field];
}

$fields[“billing”] = $ordered_fields;
$fields[‘billing’][‘billing_email’][‘priority’] = 10;
$fields[‘billing’][‘billing_first_name’][‘priority’] = 20;
$fields[‘billing’][‘billing_last_name’][‘priority’] = 30;
$fields[‘billing’][‘billing_phone’][‘priority’] = 40;
$fields[‘billing’][‘billing_country’][‘priority’] = 50;
$fields[‘billing’][‘billing_state’][‘priority’] = 60;
$fields[‘billing’][‘billing_city’][‘priority’] = 70;
$fields[‘billing’][‘billing_address_1’][‘priority’] = 80;


return $fields;

}

/**
 * @snippet       Rename State Field Label @ WooCommerce Checkout
 */
 
add_filter( 'woocommerce_default_address_fields' , 'bbloomer_rename_state_province', 9999 );
 
function bbloomer_rename_state_province( $fields ) {
    $fields['state']['label'] = 'Shipping Zone';
    return $fields;
}

/**
* @snippet     Rename a Default Sorting Option @ WooCommerce Shop
*/
 
add_filter( 'woocommerce_catalog_orderby', 'sptworld_rename_sorting_option_woocommerce_shop' );
 
function sptworld_rename_sorting_option_woocommerce_shop( $options ) {
   $options['menu_order'] = __( 'Sort by', 'woocommerce' );   
   return $options;
}

add_action('woocommerce_before_checkout_form', 'bbloomer_print_cart_weight');
add_action('woocommerce_before_cart', 'bbloomer_print_cart_weight');
 
function bbloomer_print_cart_weight( $posted ) {
global $woocommerce;
$notice = 'Your cart weight is: ' . $woocommerce->cart->cart_contents_weight . get_option('woocommerce_weight_unit');
if( is_cart() ) {
   wc_print_notice( $notice, 'notice' );
} else {
   wc_add_notice( $notice, 'notice' );
}
}